<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:param name="field">MVSVGNo</xsl:param>
<xsl:param name="datatype">number</xsl:param>
<xsl:param name="orderby">ascending</xsl:param>
<xsl:output method="html"/>
<xsl:template match="/">
<p class="bold">Attributs de <xsl:value-of select="map/titel" /></p>
<p>(Instructions: Bougez le curseur sur la ligne pour slectionner l'objet sur la carte. Appuyez sur la touche CTRL en mme temps pour zoomer sur l'objet.)</p>
<table cellspacing="0" cellpadding="3" class="recTable">
<tr>
<th>N</th>
<xsl:for-each select="map/tabelle/fields/*">
<th>
<nobr>
<xsl:value-of select="." />
<a>
<xsl:attribute name="href">javascript:sortTable('<xsl:number level="single" count="fields/*" format="1" />','<xsl:value-of select="@datatype" />','ascending');</xsl:attribute>
<img src="../pictures/sortascending.png" width="16" height="16" border="0" style="margin-left:10px;margin-right:5px" alt="Tri croissant" />
</a>
<a>
<xsl:attribute name="href">javascript:sortTable('<xsl:number level="single" count="fields/*" format="1" />','<xsl:value-of select="@datatype" />','descending');</xsl:attribute>
<img src="../pictures/sortdescending.png" width="16" height="16" border="0" alt="Tri decroissant" />
</a>
</nobr>
</th>
</xsl:for-each>
<th><xsl:value-of select="map/tabelle/fieldLi" /></th>
</tr>
<xsl:for-each select="map/tabelle/records/rec">
<xsl:sort data-type="{$datatype}" order="{$orderby}" lang="en" select="custom/*[local-name() = $field]"  />
<tr style="font-weight:normal;cursor:default">
<xsl:attribute name="onmouseover">window.opener.hiliteRec('<xsl:for-each select="tiles/*"><xsl:value-of select="." />,</xsl:for-each><xsl:value-of select="@id" />','<xsl:value-of select="MVSVGXMin" />','<xsl:value-of select="MVSVGXMax" />','<xsl:value-of select="MVSVGYMin" />','<xsl:value-of select="MVSVGYMax" />',this,window,event);</xsl:attribute>
<xsl:attribute name="onmouseout">window.opener.hiliteRecOut(this);</xsl:attribute>
<td style="border:tan 1px solid"><xsl:value-of select="MVSVGNo" /></td>
<xsl:for-each select="custom/*">
<td style="border:tan 1px solid"><xsl:value-of select="." />&#160;</td>
</xsl:for-each>
<td style="border:tan 1px solid"><a style="color:#BEA27A;text-decoration:none">
<xsl:attribute name="href"><xsl:value-of select="MVSVGLK" /><xsl:value-of select="MVSVGLi" /></xsl:attribute>
<xsl:attribute name="target">MVSVGWin</xsl:attribute>
<xsl:value-of select="MVSVGLi" /></a></td>
</tr>
</xsl:for-each>
</table>
</xsl:template>
</xsl:stylesheet>
